/*****************************************************************************
 *   mtimer.c: MSCSS Timer C file for Philips LPC29xx Family Microprocessors
 *
 *   Copyright(C) 2007, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *   2007.09.01  ver 1.00    Preliminary version, first Release
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/
 
#include "LPC29xx.h"			/* LPC29xx Peripheral Registers	*/
#include "type.h"
#include "target.h"
#include "irq.h"
#include "mtimer.h"


/* MSCSS timer and regular timer have different base address, they have 
identical registers setting. Each timer also has its own VIC entry.
The MSCSS timer interval is controlled by MSCSS_CLK_CONF while
the regular timer interval is controlled by TMR_CLK_CONF. Other than
that, the configuration of these timers are the same. */ 
  
/******************************************************************************
** Function name:		MTimer0_Handler
**
** Descriptions:		MSCSS Timer/Counter0 interrupt handler
**
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void MTimer0_Handler( void )
{
	DWORD regVal;
	regVal = MTIM0_INT_STATUS;
	//if(regVal&(1<<1))GPIO0_OR |= (1<<18);
	//if(regVal&(1<<2))GPIO0_OR |= (1<<19);
	MTIM0_INT_CLR_STATUS = regVal;
	return;
}

/******************************************************************************
** Function name:		enable_mtimer
**
** Descriptions:		Enable MSCSS timer
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void enable_mtimer0( void )
{
	MTIM0_TCR = (1<<1);			/* Counter reset */
	MTIM0_TCR &= ~(1<<1);
	MTIM0_TCR |= (1<<0);		/* Enable counter */
	MTIM0_INT_SET_ENABLE = (1<<1)|(1<<2);
	return;
}

/******************************************************************************
** Function name:		disable_mtimer
**
** Descriptions:		Disable MSCSS timer
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void disable_mtimer0( void )
{
	MTIM0_TCR = 1<<1;			/* Counter reset */
	MTIM0_TCR &= ~(1<<1);
	MTIM0_TCR &= ~(1<<0);		/* Disable counter */
	MTIM0_INT_CLR_ENABLE = (1<<1)|(1<<2);;
	return;
}

/******************************************************************************
** Function name:		init_mtimer
**
** Descriptions:		Initialize MSCSS timer, set timer interval, reset timer,
**						install timer interrupt handler
**
** parameters:			None
** Returned value:		None
** 
******************************************************************************/
void init_mtimer0( DWORD timer_interval ) 
{
	MTIM0_TCR = 1<<1;			/* Reset counter */
		
	MTIM0_PR = 0; 					// 120MHz
	MTIM0_MCR = (1<<6);				// Reset Mtimer0 on Match3
	
	MTIM0_MR1 = 0;					// Match for ADC1
	MTIM0_MR2 =	0;					// Match for ADC2
	MTIM0_MR3 = timer_interval;		// Set MATCH3 register for reset value 

	MTIM0_EMR |= (0x3<<10)|(0x3<<8)|(0x3<<6);	// Toggle external match1 = ADC1, match2 = ADC2, match 3 = PWM0 sync

	install_irq( MSCSS_TMR0_INT, (void *)MTimer0_Handler, HIGHEST_PRIORITY);
	EnableIntReq_IRQ( MSCSS_TMR0_INT, ACTIVE_HIGH, HIGHEST_PRIORITY);
	
	return;
}
/******************************************************************************
**                            End Of File
******************************************************************************/
